<?php defined('SYSPATH') or die('No direct script access.');

class Refactor_filter_list extends Migration{
    public $schema = 'public';
    public $table = 'filter_list';

    public function up(){
        $filter_list_items = ORM::factory('Filter_Regex')->find_all();
        $filter_list_links = [];
        foreach($filter_list_items as $filter_list_item)
        {
            $filter_list_links[$filter_list_item->filter_list_id][] = $filter_list_item->data;
        }
        $this->rename_table($this->table, 'users_queries');
        $this->add_column('users_queries', 'host', ['text', 'null' => false, 'default' => '']);
        $this->add_column('users_queries', 'host_check_strong', ['boolean', 'null' => false, 'default' => DB::expr('false')]);
        $this->add_column('users_queries', 'net', ['text', 'null' => false, 'default' => '']);
        $this->add_column('users_queries', 'length', ['integer', 'null' => true]);
        $this->add_column('users_queries', 'referrer', ['text', 'null' => false, 'default' => '']);
        $this->add_column('users_queries', 'link_check_strong', ['boolean', 'null' => false, 'default' => DB::expr('false')]);
        $this->add_column('users_queries', 'link', ['text', 'null' => false, 'default' => '']);
        $this->add_column('users_queries', 'date_start', ['date', 'null' => true]);
        $this->add_column('users_queries', 'date_end', ['date', 'null' => true]);
        //$this->add_column($this->table, 'date_preset', ['enum', 'null' => true, 'options' => ['lastday','lastweek','lastmonth','last3months','lasthalfyear']]);
        
        foreach($filter_list_links as $filter_list_id => $filter_list_link) {
            $filter_list = ORM::factory('User_Query', $filter_list_id);
            $filter_list->link = implode('|', $filter_list_link);
            $filter_list->save();
        }
        
        $this->drop_table(ORM::factory('Filter_Regex')->table_name());
    }

    public function down(){
        $filter_lists = ORM::factory('User_Query')->find_all();
        $filter_list_links = [];
        foreach($filter_lists as $filter_list) {
            $filter_list_links[$filter_list->id] = explode('|', $filter_list->link);
        }
        
        $this->remove_column('users_queries', 'date_end');
        $this->remove_column('users_queries', 'date_start');
        $this->remove_column('users_queries', 'link_check_strong');
        $this->remove_column('users_queries', 'link');
        $this->remove_column('users_queries', 'referrer');
        $this->remove_column('users_queries', 'length');
        $this->remove_column('users_queries', 'net');
        $this->remove_column('users_queries', 'host_check_strong');
        $this->remove_column('users_queries', 'host');
        $this->rename_table('users_queries', $this->table);

        $this->create_table('filter_regex', [
                'filter_list_id' => ['integer', 'null' => true],
                'data' => ['text', 'null' => true],
            ], true);
        $this->run_query("ALTER TABLE ONLY filter_regex ADD CONSTRAINT filter_regex_filter_list_id_fkey FOREIGN KEY (filter_list_id) REFERENCES filter_list(id);");
        
        foreach($filter_list_links as $filter_list_id => $filter_list_links) {
            foreach($filter_list_links as $filter_list_link) {
                $filter_list_item = ORM::factory('Filter_Regex');
                $filter_list_item->filter_list_id = $filter_list_id;
                $filter_list_item->data = $filter_list_link;
                $filter_list_item->save();
            }
        }
    }
    
}